package com.hero.objects.characteristics;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.EnhancedPerception;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Intelligence extends Characteristic {

    private static String xmlID = "INT";

    public Intelligence(Element template) {
        super(template, Intelligence.xmlID);
    }

    @Override
    public int getType() {
        return Constants.INT;
    }

    @Override
    public String getDisplayNotes() {
        return "PER Roll " + getPERRoll();
    }

    /**
     * Returns the overall PER Roll for the character (split value, if
     * necessary)
     * 
     * @return
     */
    public String getPERRoll() {
        int base1 = 11;
        int base2 = 11;
        if (this.getPerIncrease() > 0 && this.getPerIncreaseLevels() > 0) {
        	int levels = (int)Rounder.roundHalfUp(getPrimaryValue()/getPerIncreaseLevels());
        	base1 = (int) (9 + Rounder.roundHalfUp(levels*getPerIncrease()));
        	levels = (int)Rounder.roundHalfUp(getSecondaryValue()/getPerIncreaseLevels());
        	base2 = (int) (9 + Rounder.roundHalfUp(levels*getPerIncrease()));
        }
        int bonus = 0;
        int secBonus = 0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
            if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getPowers()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getLevels();
                } else {
                    secBonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getPowers().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getLevels();
                        } else if (p.getSelectedOption() != null) {
                            secBonus += p.getLevels();
                        }
                    }
                }
            }
        }
        for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
            if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getEquipment()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getLevels();
                } else {
                    secBonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getEquipment().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getLevels();
                        } else if (p.getSelectedOption() != null) {
                            secBonus += p.getLevels();
                        }
                    }
                }
            }
        }
        base1 = base1 + bonus;
        base2 = base2 + bonus + secBonus;
        String ret = "" + base1 + "-";
        if (base1 != base2) {
            ret += "/" + base2 + "-";
        }
        return ret;
    }

    /**
     * Returns the primary value for the PER Roll for the character
     * 
     * @return
     */
    public int getPrimaryPERRoll() {
        int base1 = (int) (9 + Rounder.roundHalfUp((getPrimaryValue() / 5d)));
        int bonus = 0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
            if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getPowers()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getPowers().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getLevels();
                        }
                    }
                }
            }
        }
        for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
            if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getEquipment()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getEquipment().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getLevels();
                        }
                    }
                }
            }
        }
        base1 = base1 + bonus;
        return base1;
    }

    /**
     * Returns the secondary value for the PER Roll for the character.
     * 
     * @return
     */
    public int getSecondaryPERRoll() {
        int base2 = (int) (9 + Rounder.roundHalfUp((getSecondaryValue() / 5d)));
        int bonus = 0;
        int secBonus = 0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
            if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getPowers()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getSelectedOption().getLevels();
                } else if (ep.getSelectedOption() != null) {
                    secBonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getPowers().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getSelectedOption().getLevels();
                        } else if (p.getSelectedOption() != null) {
                            secBonus += p.getLevels();
                        }
                    }
                }
            }
        }
        for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
            if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof EnhancedPerception) {
                GenericObject ep = HeroDesigner.getActiveHero().getEquipment()
                        .get(i);
                if (ep.getSelectedOption() != null
                        && ep.getSelectedOption().getXMLID().equals("ALL")) {
                    bonus += ep.getSelectedOption().getLevels();
                } else if (ep.getSelectedOption() != null) {
                    secBonus += ep.getLevels();
                }
            } else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
                CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
                        .getEquipment().get(i);
                for (GenericObject p : cp.getPowers()) {
                    if (p instanceof EnhancedPerception) {
                        if (p.getSelectedOption() != null
                                && p.getSelectedOption().getXMLID().equals(
                                        "ALL")) {
                            bonus += p.getSelectedOption().getLevels();
                        } else if (p.getSelectedOption() != null) {
                            secBonus += p.getLevels();
                        }
                    }
                }
            }
        }
        base2 = base2 + bonus + secBonus;
        return base2;
    }

}